% ------------------------------------------------------------------------
% Este script hace una grfica con los errores de truncamiento
% del mtodo de Euler, Leapfrog y RK4 para el problema de la desintegracin
% radioactiva en funcin del tamao del paso h.
% ------------------------------------------------------------------------

%Definiciones y parmetros

k=1;
fun = @(t,y) -k*y;
fexact = @(t,y0) y0*exp(-k*t);
y0=100;
t0=0;
tf=5;
Np=20;  % Nmero de valores en la figura

%Calculamos el mximo error de truncamiento para cada tamao de paso

eEuler=zeros(1,Np);
eLeap=zeros(1,Np);
eRK=zeros(1,Np);
h=zeros(1,Np);
Nh = 10:10:10*Np;
for j=1:1:Np
    [te,ye]=feuler(fun,t0,tf,y0,Nh(j));
    [tl,yl]=fLeapfrog(fun,t0,tf,y0,Nh(j));
    [tRK,yRK]=fRK4(fun,t0,tf,y0,Nh(j));
    yp=fexact(te,y0);
    elEuler=abs(yp-ye);
    elLeap=abs(yp-yl);
    elRK=abs(yp-yRK);
    eEuler(j)=max(elEuler); % Mximo error de truncamiento del mtodo de Euler
    eLeap(j)=max(elLeap);   % Mximo error de truncamiento del mtodo Leapfrog
    eRK(j)=max(elRK);       % Mximo error de truncamiento del mtodo RK4
    h(j)=(tf-t0)/Nh(j);
end

%Ajustamos los errores del mtodo de Euler de la forma e=c*h

xy=eEuler.*h;
yy=eEuler.*eEuler;
a=sum(yy);
b=sum(xy);
c=a/b;
Eulerfit=c*h;

%Ajustamos los errores del mtodo Leapfrog de la forma e=c*h^2

yy=eLeap.*eLeap;
hsqr=h.*h;
xy=eLeap.*hsqr;
a=sum(yy);
b=sum(xy);
c=a/b;
Leapfit=c*hsqr;

%Ajustamos los errores del mtodo RK4 de la forma e=c*h^4

yy=eRK.*eRK;
h4=h.^4;
xy=eRK.*h4;
a=sum(yy);
b=sum(xy);
c=a/b;
RKfit=c*h4;

%Representamos la figura

loglog(h,eEuler,'o',h,Eulerfit,'-k',h,eLeap,'+k',h,Leapfit,'-k',h,eRK,'ok',h,RKfit,'-k');
xlabel('h');
ylabel('Error global de truncamiento');
title('Comparativa Euler-Leapfrog-RK4');
legend('Euler','E=cte*h (Euler)','Leapfrog','E=cte*h^2 (Leap)','RK','E=cte*h^4 (RK)','Location','SouthEast');
